package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ComanagementEligibleType implements Enum {

    @JsonProperty("comanaged")
    COMANAGED("comanaged", "1"),

    @JsonProperty("eligible")
    ELIGIBLE("eligible", "2"),

    @JsonProperty("eligibleButNotAzureAdJoined")
    ELIGIBLE_BUT_NOT_AZURE_AD_JOINED("eligibleButNotAzureAdJoined", "3"),

    @JsonProperty("needsOsUpdate")
    NEEDS_OS_UPDATE("needsOsUpdate", "4"),

    @JsonProperty("ineligible")
    INELIGIBLE("ineligible", "5");

    private final String name;
    private final String value;

    private ComanagementEligibleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
