package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ChatMessageType implements Enum {

    @JsonProperty("message")
    MESSAGE("message", "0"),

    @JsonProperty("chatEvent")
    CHAT_EVENT("chatEvent", "1"),

    @JsonProperty("typing")
    TYPING("typing", "2");

    private final String name;
    private final String value;

    private ChatMessageType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
