package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ChatMessagePolicyViolationVerdictDetailsTypes implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("allowFalsePositiveOverride")
    ALLOW_FALSE_POSITIVE_OVERRIDE("allowFalsePositiveOverride", "1"),

    @JsonProperty("allowOverrideWithoutJustification")
    ALLOW_OVERRIDE_WITHOUT_JUSTIFICATION("allowOverrideWithoutJustification", "2"),

    @JsonProperty("allowOverrideWithJustification")
    ALLOW_OVERRIDE_WITH_JUSTIFICATION("allowOverrideWithJustification", "4");

    private final String name;
    private final String value;

    private ChatMessagePolicyViolationVerdictDetailsTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
