package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ChatMessagePolicyViolationDlpActionTypes implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("notifySender")
    NOTIFY_SENDER("notifySender", "1"),

    @JsonProperty("blockAccess")
    BLOCK_ACCESS("blockAccess", "2"),

    @JsonProperty("blockAccessExternal")
    BLOCK_ACCESS_EXTERNAL("blockAccessExternal", "4");

    private final String name;
    private final String value;

    private ChatMessagePolicyViolationDlpActionTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
