package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ChatMessageImportance implements Enum {

    @JsonProperty("normal")
    NORMAL("normal", "0"),

    @JsonProperty("high")
    HIGH("high", "1"),

    @JsonProperty("urgent")
    URGENT("urgent", "2");

    private final String name;
    private final String value;

    private ChatMessageImportance(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
