package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ChannelMembershipType implements Enum {

    @JsonProperty("standard")
    STANDARD("standard", "0"),

    @JsonProperty("private")
    PRIVATE("private", "1"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2");

    private final String name;
    private final String value;

    private ChannelMembershipType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
