package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ChangeType implements Enum {

    @JsonProperty("created")
    CREATED("created", "0"),

    @JsonProperty("updated")
    UPDATED("updated", "1"),

    @JsonProperty("deleted")
    DELETED("deleted", "2");

    private final String name;
    private final String value;

    private ChangeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
