package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CertificateStatus implements Enum {

    @JsonProperty("notProvisioned")
    NOT_PROVISIONED("notProvisioned", "0"),

    @JsonProperty("provisioned")
    PROVISIONED("provisioned", "1");

    private final String name;
    private final String value;

    private CertificateStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
