package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CaseStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("active")
    ACTIVE("active", "1"),

    @JsonProperty("pendingDelete")
    PENDING_DELETE("pendingDelete", "2"),

    @JsonProperty("closing")
    CLOSING("closing", "3"),

    @JsonProperty("closed")
    CLOSED("closed", "4"),

    @JsonProperty("closedWithError")
    CLOSED_WITH_ERROR("closedWithError", "5");

    private final String name;
    private final String value;

    private CaseStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
