package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CallState implements Enum {

    @JsonProperty("incoming")
    INCOMING("incoming", "0"),

    @JsonProperty("establishing")
    ESTABLISHING("establishing", "1"),

    @JsonProperty("ringing")
    RINGING("ringing", "2"),

    @JsonProperty("established")
    ESTABLISHED("established", "3"),

    @JsonProperty("hold")
    HOLD("hold", "4"),

    @JsonProperty("transferring")
    TRANSFERRING("transferring", "5"),

    @JsonProperty("transferAccepted")
    TRANSFER_ACCEPTED("transferAccepted", "6"),

    @JsonProperty("redirecting")
    REDIRECTING("redirecting", "7"),

    @JsonProperty("terminating")
    TERMINATING("terminating", "8"),

    @JsonProperty("terminated")
    TERMINATED("terminated", "9"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "10");

    private final String name;
    private final String value;

    private CallState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
