package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CallDisposition implements Enum {

    @JsonProperty("default")
    DEFAULT("default", "0"),

    @JsonProperty("simultaneousRing")
    SIMULTANEOUS_RING("simultaneousRing", "1"),

    @JsonProperty("forward")
    FORWARD("forward", "2");

    private final String name;
    private final String value;

    private CallDisposition(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
