package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum CalendarSharingAction implements Enum {

    @JsonProperty("accept")
    ACCEPT("accept", "0"),

    @JsonProperty("acceptAndViewCalendar")
    ACCEPT_AND_VIEW_CALENDAR("acceptAndViewCalendar", "1"),

    @JsonProperty("viewCalendar")
    VIEW_CALENDAR("viewCalendar", "2"),

    @JsonProperty("addThisCalendar")
    ADD_THIS_CALENDAR("addThisCalendar", "3");

    private final String name;
    private final String value;

    private CalendarSharingAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
