package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum BookingStaffRole implements Enum {

    @JsonProperty("guest")
    GUEST("guest", "0"),

    @JsonProperty("administrator")
    ADMINISTRATOR("administrator", "1"),

    @JsonProperty("viewer")
    VIEWER("viewer", "2"),

    @JsonProperty("externalGuest")
    EXTERNAL_GUEST("externalGuest", "3");

    private final String name;
    private final String value;

    private BookingStaffRole(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
