package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum BookingReminderRecipients implements Enum {

    @JsonProperty("allAttendees")
    ALL_ATTENDEES("allAttendees", "0"),

    @JsonProperty("staff")
    STAFF("staff", "1"),

    @JsonProperty("customer")
    CUSTOMER("customer", "2");

    private final String name;
    private final String value;

    private BookingReminderRecipients(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
