package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum BitLockerRecoveryPasswordRotationType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("disabled")
    DISABLED("disabled", "1"),

    @JsonProperty("enabledForAzureAd")
    ENABLED_FOR_AZURE_AD("enabledForAzureAd", "2"),

    @JsonProperty("enabledForAzureAdAndHybrid")
    ENABLED_FOR_AZURE_AD_AND_HYBRID("enabledForAzureAdAndHybrid", "3");

    private final String name;
    private final String value;

    private BitLockerRecoveryPasswordRotationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
