package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum BitLockerEncryptionMethod implements Enum {

    @JsonProperty("aesCbc128")
    AES_CBC128("aesCbc128", "3"),

    @JsonProperty("aesCbc256")
    AES_CBC256("aesCbc256", "4"),

    @JsonProperty("xtsAes128")
    XTS_AES128("xtsAes128", "6"),

    @JsonProperty("xtsAes256")
    XTS_AES256("xtsAes256", "7");

    private final String name;
    private final String value;

    private BitLockerEncryptionMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
