package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum BinaryManagementConditionExpressionOperatorType implements Enum {

    @JsonProperty("or")
    OR("or", "0"),

    @JsonProperty("and")
    AND("and", "1");

    private final String name;
    private final String value;

    private BinaryManagementConditionExpressionOperatorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
