package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AzureADLicenseType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("free")
    FREE("free", "1"),

    @JsonProperty("basic")
    BASIC("basic", "2"),

    @JsonProperty("premiumP1")
    PREMIUM_P1("premiumP1", "3"),

    @JsonProperty("premiumP2")
    PREMIUM_P2("premiumP2", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private AzureADLicenseType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
