package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AutoAdmittedUsersType implements Enum {

    @JsonProperty("everyoneInCompany")
    EVERYONE_IN_COMPANY("everyoneInCompany", "0"),

    @JsonProperty("everyone")
    EVERYONE("everyone", "1");

    private final String name;
    private final String value;

    private AutoAdmittedUsersType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
