package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AuthenticatorAppContextType implements Enum {

    @JsonProperty("location")
    LOCATION("location", "0"),

    @JsonProperty("app")
    APP("app", "1");

    private final String name;
    private final String value;

    private AuthenticatorAppContextType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
