package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AuthenticationPhoneType implements Enum {

    @JsonProperty("mobile")
    MOBILE("mobile", "0"),

    @JsonProperty("alternateMobile")
    ALTERNATE_MOBILE("alternateMobile", "1"),

    @JsonProperty("office")
    OFFICE("office", "2"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private AuthenticationPhoneType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
