package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AuthenticationMethodSignInState implements Enum {

    @JsonProperty("notSupported")
    NOT_SUPPORTED("notSupported", "0"),

    @JsonProperty("notAllowedByPolicy")
    NOT_ALLOWED_BY_POLICY("notAllowedByPolicy", "1"),

    @JsonProperty("notEnabled")
    NOT_ENABLED("notEnabled", "2"),

    @JsonProperty("phoneNumberNotUnique")
    PHONE_NUMBER_NOT_UNIQUE("phoneNumberNotUnique", "3"),

    @JsonProperty("ready")
    READY("ready", "4"),

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private AuthenticationMethodSignInState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
