package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AuthMethodsType implements Enum {

    @JsonProperty("email")
    EMAIL("email", "0"),

    @JsonProperty("mobileSMS")
    MOBILE_SMS("mobileSMS", "1"),

    @JsonProperty("mobilePhone")
    MOBILE_PHONE("mobilePhone", "2"),

    @JsonProperty("officePhone")
    OFFICE_PHONE("officePhone", "3"),

    @JsonProperty("securityQuestion")
    SECURITY_QUESTION("securityQuestion", "4"),

    @JsonProperty("appNotification")
    APP_NOTIFICATION("appNotification", "5"),

    @JsonProperty("appNotificationCode")
    APP_NOTIFICATION_CODE("appNotificationCode", "6"),

    @JsonProperty("appNotificationAndCode")
    APP_NOTIFICATION_AND_CODE("appNotificationAndCode", "7"),

    @JsonProperty("appPassword")
    APP_PASSWORD("appPassword", "8"),

    @JsonProperty("fido")
    FIDO("fido", "9"),

    @JsonProperty("alternateMobilePhone")
    ALTERNATE_MOBILE_PHONE("alternateMobilePhone", "10"),

    @JsonProperty("mobilePhoneAndSMS")
    MOBILE_PHONE_AND_SMS("mobilePhoneAndSMS", "11"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "12");

    private final String name;
    private final String value;

    private AuthMethodsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
