package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AttributeMappingSourceType implements Enum {

    @JsonProperty("Attribute")
    ATTRIBUTE("Attribute", "0"),

    @JsonProperty("Constant")
    CONSTANT("Constant", "1"),

    @JsonProperty("Function")
    FUNCTION("Function", "2");

    private final String name;
    private final String value;

    private AttributeMappingSourceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
