package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AttributeFlowType implements Enum {

    @JsonProperty("Always")
    ALWAYS("Always", "0"),

    @JsonProperty("ObjectAddOnly")
    OBJECT_ADD_ONLY("ObjectAddOnly", "1"),

    @JsonProperty("MultiValueAddOnly")
    MULTI_VALUE_ADD_ONLY("MultiValueAddOnly", "2"),

    @JsonProperty("ValueAddOnly")
    VALUE_ADD_ONLY("ValueAddOnly", "3"),

    @JsonProperty("AttributeAddOnly")
    ATTRIBUTE_ADD_ONLY("AttributeAddOnly", "4");

    private final String name;
    private final String value;

    private AttributeFlowType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
