package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AttributeFlowBehavior implements Enum {

    @JsonProperty("FlowWhenChanged")
    FLOW_WHEN_CHANGED("FlowWhenChanged", "0"),

    @JsonProperty("FlowAlways")
    FLOW_ALWAYS("FlowAlways", "1");

    private final String name;
    private final String value;

    private AttributeFlowBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
