package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AttendeeType implements Enum {

    @JsonProperty("required")
    REQUIRED("required", "0"),

    @JsonProperty("optional")
    OPTIONAL("optional", "1"),

    @JsonProperty("resource")
    RESOURCE("resource", "2");

    private final String name;
    private final String value;

    private AttendeeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
