package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AttachmentType implements Enum {

    @JsonProperty("file")
    FILE("file", "0"),

    @JsonProperty("item")
    ITEM("item", "1"),

    @JsonProperty("reference")
    REFERENCE("reference", "2");

    private final String name;
    private final String value;

    private AttachmentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
