package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AssignmentMethod implements Enum {

    @JsonProperty("standard")
    STANDARD("standard", "0"),

    @JsonProperty("privileged")
    PRIVILEGED("privileged", "1"),

    @JsonProperty("auto")
    AUTO("auto", "2");

    private final String name;
    private final String value;

    private AssignmentMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
