package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ApprovalState implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "0"),

    @JsonProperty("approved")
    APPROVED("approved", "1"),

    @JsonProperty("denied")
    DENIED("denied", "2"),

    @JsonProperty("aborted")
    ABORTED("aborted", "3"),

    @JsonProperty("canceled")
    CANCELED("canceled", "4");

    private final String name;
    private final String value;

    private ApprovalState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
