package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppliedConditionalAccessPolicyResult implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("failure")
    FAILURE("failure", "1"),

    @JsonProperty("notApplied")
    NOT_APPLIED("notApplied", "2"),

    @JsonProperty("notEnabled")
    NOT_ENABLED("notEnabled", "3"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5"),

    @JsonProperty("reportOnlySuccess")
    REPORT_ONLY_SUCCESS("reportOnlySuccess", "6"),

    @JsonProperty("reportOnlyFailure")
    REPORT_ONLY_FAILURE("reportOnlyFailure", "7"),

    @JsonProperty("reportOnlyNotApplied")
    REPORT_ONLY_NOT_APPLIED("reportOnlyNotApplied", "8"),

    @JsonProperty("reportOnlyInterrupted")
    REPORT_ONLY_INTERRUPTED("reportOnlyInterrupted", "9");

    private final String name;
    private final String value;

    private AppliedConditionalAccessPolicyResult(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
