package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ApplicationType implements Enum {

    @JsonProperty("universal")
    UNIVERSAL("universal", "1"),

    @JsonProperty("desktop")
    DESKTOP("desktop", "2");

    private final String name;
    private final String value;

    private ApplicationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
