package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppleVpnConnectionType implements Enum {

    @JsonProperty("ciscoAnyConnect")
    CISCO_ANY_CONNECT("ciscoAnyConnect", "0"),

    @JsonProperty("pulseSecure")
    PULSE_SECURE("pulseSecure", "1"),

    @JsonProperty("f5EdgeClient")
    F5EDGE_CLIENT("f5EdgeClient", "2"),

    @JsonProperty("dellSonicWallMobileConnect")
    DELL_SONIC_WALL_MOBILE_CONNECT("dellSonicWallMobileConnect", "3"),

    @JsonProperty("checkPointCapsuleVpn")
    CHECK_POINT_CAPSULE_VPN("checkPointCapsuleVpn", "4"),

    @JsonProperty("customVpn")
    CUSTOM_VPN("customVpn", "5"),

    @JsonProperty("ciscoIPSec")
    CISCO_IPSEC("ciscoIPSec", "6"),

    @JsonProperty("citrix")
    CITRIX("citrix", "7"),

    @JsonProperty("ciscoAnyConnectV2")
    CISCO_ANY_CONNECT_V2("ciscoAnyConnectV2", "8"),

    @JsonProperty("paloAltoGlobalProtect")
    PALO_ALTO_GLOBAL_PROTECT("paloAltoGlobalProtect", "9"),

    @JsonProperty("zscalerPrivateAccess")
    ZSCALER_PRIVATE_ACCESS("zscalerPrivateAccess", "10"),

    @JsonProperty("f5Access2018")
    F5ACCESS2018("f5Access2018", "11"),

    @JsonProperty("citrixSso")
    CITRIX_SSO("citrixSso", "12"),

    @JsonProperty("paloAltoGlobalProtectV2")
    PALO_ALTO_GLOBAL_PROTECT_V2("paloAltoGlobalProtectV2", "13"),

    @JsonProperty("ikEv2")
    IK_EV2("ikEv2", "14"),

    @JsonProperty("alwaysOn")
    ALWAYS_ON("alwaysOn", "15"),

    @JsonProperty("microsoftTunnel")
    MICROSOFT_TUNNEL("microsoftTunnel", "16");

    private final String name;
    private final String value;

    private AppleVpnConnectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
