package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppleSubjectNameFormat implements Enum {

    @JsonProperty("commonName")
    COMMON_NAME("commonName", "0"),

    @JsonProperty("commonNameAsEmail")
    COMMON_NAME_AS_EMAIL("commonNameAsEmail", "1"),

    @JsonProperty("custom")
    CUSTOM("custom", "2"),

    @JsonProperty("commonNameIncludingEmail")
    COMMON_NAME_INCLUDING_EMAIL("commonNameIncludingEmail", "3"),

    @JsonProperty("commonNameAsIMEI")
    COMMON_NAME_AS_IMEI("commonNameAsIMEI", "5"),

    @JsonProperty("commonNameAsSerialNumber")
    COMMON_NAME_AS_SERIAL_NUMBER("commonNameAsSerialNumber", "6");

    private final String name;
    private final String value;

    private AppleSubjectNameFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
