package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppManagementLevel implements Enum {

    @JsonProperty("unspecified")
    UNSPECIFIED("unspecified", "0"),

    @JsonProperty("unmanaged")
    UNMANAGED("unmanaged", "1"),

    @JsonProperty("mdm")
    MDM("mdm", "2"),

    @JsonProperty("androidEnterprise")
    ANDROID_ENTERPRISE("androidEnterprise", "4");

    private final String name;
    private final String value;

    private AppManagementLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
