package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppLogUploadState implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "0"),

    @JsonProperty("completed")
    COMPLETED("completed", "1"),

    @JsonProperty("failed")
    FAILED("failed", "2");

    private final String name;
    private final String value;

    private AppLogUploadState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
