package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppListType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("appsInListCompliant")
    APPS_IN_LIST_COMPLIANT("appsInListCompliant", "1"),

    @JsonProperty("appsNotInListCompliant")
    APPS_NOT_IN_LIST_COMPLIANT("appsNotInListCompliant", "2");

    private final String name;
    private final String value;

    private AppListType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
