package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AppInstallControlType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("anywhere")
    ANYWHERE("anywhere", "1"),

    @JsonProperty("storeOnly")
    STORE_ONLY("storeOnly", "2"),

    @JsonProperty("recommendations")
    RECOMMENDATIONS("recommendations", "3"),

    @JsonProperty("preferStore")
    PREFER_STORE("preferStore", "4");

    private final String name;
    private final String value;

    private AppInstallControlType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
