package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidUsernameSource implements Enum {

    @JsonProperty("username")
    USERNAME("username", "0"),

    @JsonProperty("userPrincipalName")
    USER_PRINCIPAL_NAME("userPrincipalName", "1"),

    @JsonProperty("samAccountName")
    SAM_ACCOUNT_NAME("samAccountName", "2"),

    @JsonProperty("primarySmtpAddress")
    PRIMARY_SMTP_ADDRESS("primarySmtpAddress", "3");

    private final String name;
    private final String value;

    private AndroidUsernameSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
