package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidForWorkVpnConnectionType implements Enum {

    @JsonProperty("ciscoAnyConnect")
    CISCO_ANY_CONNECT("ciscoAnyConnect", "0"),

    @JsonProperty("pulseSecure")
    PULSE_SECURE("pulseSecure", "1"),

    @JsonProperty("f5EdgeClient")
    F5EDGE_CLIENT("f5EdgeClient", "2"),

    @JsonProperty("dellSonicWallMobileConnect")
    DELL_SONIC_WALL_MOBILE_CONNECT("dellSonicWallMobileConnect", "3"),

    @JsonProperty("checkPointCapsuleVpn")
    CHECK_POINT_CAPSULE_VPN("checkPointCapsuleVpn", "4"),

    @JsonProperty("citrix")
    CITRIX("citrix", "5");

    private final String name;
    private final String value;

    private AndroidForWorkVpnConnectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
