package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidForWorkSyncStatus implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("credentialsNotValid")
    CREDENTIALS_NOT_VALID("credentialsNotValid", "1"),

    @JsonProperty("androidForWorkApiError")
    ANDROID_FOR_WORK_API_ERROR("androidForWorkApiError", "2"),

    @JsonProperty("managementServiceError")
    MANAGEMENT_SERVICE_ERROR("managementServiceError", "3"),

    @JsonProperty("unknownError")
    UNKNOWN_ERROR("unknownError", "4"),

    @JsonProperty("none")
    NONE("none", "5");

    private final String name;
    private final String value;

    private AndroidForWorkSyncStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
