package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidForWorkRequiredPasswordType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("lowSecurityBiometric")
    LOW_SECURITY_BIOMETRIC("lowSecurityBiometric", "1"),

    @JsonProperty("required")
    REQUIRED("required", "2"),

    @JsonProperty("atLeastNumeric")
    AT_LEAST_NUMERIC("atLeastNumeric", "3"),

    @JsonProperty("numericComplex")
    NUMERIC_COMPLEX("numericComplex", "4"),

    @JsonProperty("atLeastAlphabetic")
    AT_LEAST_ALPHABETIC("atLeastAlphabetic", "5"),

    @JsonProperty("atLeastAlphanumeric")
    AT_LEAST_ALPHANUMERIC("atLeastAlphanumeric", "6"),

    @JsonProperty("alphanumericWithSymbols")
    ALPHANUMERIC_WITH_SYMBOLS("alphanumericWithSymbols", "7");

    private final String name;
    private final String value;

    private AndroidForWorkRequiredPasswordType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
