package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidEapType implements Enum {

    @JsonProperty("eapTls")
    EAP_TLS("eapTls", "13"),

    @JsonProperty("eapTtls")
    EAP_TTLS("eapTtls", "21"),

    @JsonProperty("peap")
    PEAP("peap", "25");

    private final String name;
    private final String value;

    private AndroidEapType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
