package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidDeviceOwnerWiFiSecurityType implements Enum {

    @JsonProperty("open")
    OPEN("open", "0"),

    @JsonProperty("wep")
    WEP("wep", "1"),

    @JsonProperty("wpaPersonal")
    WPA_PERSONAL("wpaPersonal", "2"),

    @JsonProperty("wpaEnterprise")
    WPA_ENTERPRISE("wpaEnterprise", "4");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerWiFiSecurityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
