package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidDeviceOwnerRequiredPasswordType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("required")
    REQUIRED("required", "1"),

    @JsonProperty("numeric")
    NUMERIC("numeric", "2"),

    @JsonProperty("numericComplex")
    NUMERIC_COMPLEX("numericComplex", "3"),

    @JsonProperty("alphabetic")
    ALPHABETIC("alphabetic", "4"),

    @JsonProperty("alphanumeric")
    ALPHANUMERIC("alphanumeric", "5"),

    @JsonProperty("alphanumericWithSymbols")
    ALPHANUMERIC_WITH_SYMBOLS("alphanumericWithSymbols", "6"),

    @JsonProperty("lowSecurityBiometric")
    LOW_SECURITY_BIOMETRIC("lowSecurityBiometric", "7"),

    @JsonProperty("customPassword")
    CUSTOM_PASSWORD("customPassword", "8");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerRequiredPasswordType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
