package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidDeviceOwnerKioskModeScreenOrientation implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("portrait")
    PORTRAIT("portrait", "1"),

    @JsonProperty("landscape")
    LANDSCAPE("landscape", "2"),

    @JsonProperty("autoRotate")
    AUTO_ROTATE("autoRotate", "3");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerKioskModeScreenOrientation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
