package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidDeviceOwnerEnrollmentProfileType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("dedicatedDevice")
    DEDICATED_DEVICE("dedicatedDevice", "1"),

    @JsonProperty("fullyManaged")
    FULLY_MANAGED("fullyManaged", "2");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerEnrollmentProfileType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
