package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AndroidDeviceOwnerBatteryPluggedMode implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("ac")
    AC("ac", "1"),

    @JsonProperty("usb")
    USB("usb", "2"),

    @JsonProperty("wireless")
    WIRELESS("wireless", "3");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerBatteryPluggedMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
