package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Alignment implements Enum {

    @JsonProperty("left")
    LEFT("left", "0"),

    @JsonProperty("right")
    RIGHT("right", "1"),

    @JsonProperty("center")
    CENTER("center", "2");

    private final String name;
    private final String value;

    private Alignment(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
