package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum AlertFeedback implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("truePositive")
    TRUE_POSITIVE("truePositive", "1"),

    @JsonProperty("falsePositive")
    FALSE_POSITIVE("falsePositive", "2"),

    @JsonProperty("benignPositive")
    BENIGN_POSITIVE("benignPositive", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private AlertFeedback(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
